<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://codecanyon.net/user/butsokoy
 * @since             1.0.0
 * @package           Gform_Starrating_Field
 *
 * @wordpress-plugin
 * Plugin Name:       Gravity Forms Star Rating Field
 * Plugin URI:        https://codecanyon.net/user/butsokoy/portfolio
 * Description:       Add star rating fields on your Gravity Forms 
 * Version:           1.4
 * Author:            Butsokoy
 * Author URI:        https://codecanyon.net/user/butsokoy
 * Text Domain:       gform-starrating-field
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-gform-starrating-field-activator.php
 */
function activate_gform_starrating_field() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gform-starrating-field-activator.php';
	Gform_Starrating_Field_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-gform-starrating-field-deactivator.php
 */
function deactivate_gform_starrating_field() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gform-starrating-field-deactivator.php';
	Gform_Starrating_Field_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_gform_starrating_field' );
register_deactivation_hook( __FILE__, 'deactivate_gform_starrating_field' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-gform-starrating-field.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_gform_starrating_field() {

	if ( class_exists( 'GFForms' ) ) {
	    $plugin = new Gform_Starrating_Field();
		$plugin->run();
	}

}
add_action( 'plugins_loaded', 'run_gform_starrating_field', 88 );