<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://codecanyon.net/user/butsokoy
 * @since      1.0.0
 *
 * @package    Gform_Starrating_Field
 * @subpackage Gform_Starrating_Field/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Gform_Starrating_Field
 * @subpackage Gform_Starrating_Field/admin
 * @author     butsokoy <luffy2015x@gmail.com>
 */
class Gform_Starrating_Field_Gravity {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the JavaScript and Style for Gravity Form.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css');
		wp_enqueue_style('jbstar-rating', plugin_dir_url( dirname(__FILE__) ) . 'shared/css/jquery.barrating.css', array(), $this->version, 'all' );
		wp_enqueue_script('jbstar-rating', plugin_dir_url( dirname(__FILE__) ) . 'shared/js/jquery.barrating.min.js', array( 'jquery' ), $this->version, true );

		wp_enqueue_style('jbstar-html5toltips', plugin_dir_url( dirname(__FILE__) ) . 'shared/css/html5tooltips.css', array(), $this->version, 'all' );
		wp_enqueue_script('jbstar-html5toltips', plugin_dir_url( dirname(__FILE__) ) . 'shared/js/html5tooltips.js', array(), $this->version, true );

		wp_enqueue_script($this->plugin_name, plugin_dir_url( dirname(__FILE__) ) . 'public/js/gform-starrating-field-public.js', array( ), $this->version, true );
	}

	/**
	 * Inject Javascript into the Gravity form editor page.
	 *
	 * @since    1.0.0
	 */
	public function editor_js() {
		?>
	    <script type='text/javascript'>

	        //adding setting to fields of type "jb_starrating"
	        fieldSettings.jb_starrating += ', .jb_starrating_theme_setting';
	        fieldSettings.jb_starrating += ', .jb_starrating_show_selected_setting';
	        fieldSettings.jb_starrating += ', .jb_starrating_show_tooltip_setting';
	        fieldSettings.jb_starrating += ', .jb_starrating_deselectable_setting';

	        jQuery(document).bind('gform_load_field_settings', function(event, field, form){

	            if (field.type == 'jb_starrating') {

	            	if(typeof field.jbStarratingTheme == 'undefined' || field.jbStarratingTheme == "")
	            		field.jbStarratingTheme = 'fontawesome-stars';

	            	if(typeof field.jbStarratingShowSelected == 'undefined' || field.jbStarratingShowSelected == "")
	            		field.jbStarratingShowSelected = false;

	            	if(typeof field.jbStarratingShowTooltip == 'undefined' || field.jbStarratingShowTooltip == "")
	            		field.jbStarratingShowTooltip = false;

	            	if(typeof field.jbStarratingDeselectable == 'undefined' || field.jbStarratingDeselectable == "")
	            		field.jbStarratingDeselectable = false;

	                var el_field = jQuery('#field_'+field.id);

	                if(field.defaultValue == ""){
	                    jQuery.each(field.choices,function(i,choice){
	                        if(field.defaultValue == ""){
	                            choice.isSelected = false;
	                        }
	                    });

	                    setTimeout(function(){
	                        var choices = el_field.find('.field-choice-row[data-input_type="jb_starrating"] [type="radio"]');
	                        choices.each(function(){
	                            jQuery(this).prop('checked',false);
	                        });
	                    });
	                }

	            	jQuery('#jb_starrating_theme').val(field.jbStarratingTheme);
	            	jQuery('#jb_starrating_show_selected').prop('checked', field.jbStarratingShowSelected);
	            	jQuery('#jb_starrating_show_tooltip').prop('checked', field.jbStarratingShowTooltip);
	            	jQuery('#jb_starrating_deselectable').prop('checked', field.jbStarratingDeselectable);
	            }
	        });

	        jQuery(document).bind("gform_field_added", function(event, form, field){
	            if (field.type == 'jb_starrating') {
	                initializeJbStarrating(jQuery('.gfield_jb_starrating'));
	            }
	        });

	        jQuery(document).ready(function($){

	        	$(document).on('change', '.jb_starrating_theme', function(){
	        		var el_select = $(this).closest('li.gfield').find('.gfield_jb_starrating');
	        			el_select.attr('data-starrating-theme', $(this).val());

	        		SetFieldProperty('jbStarratingTheme', $(this).val());

	        		if(el_select.find('option').length)
	        			initializeJbStarrating(el_select);
	        	});

	        	$(document).on('change', '.jb_starrating_show_selected', function(){
	        		var el_select = $(this).closest('li.gfield').find('.gfield_jb_starrating');
	        			el_select.attr('data-starrating-show-selected', $(this).prop('checked'));

	        		SetFieldProperty('jbStarratingShowSelected', $(this).prop('checked'));
	        		
	        		if(el_select.find('option').length)
	        			initializeJbStarrating(el_select);
	        	});

	        	$(document).on('change', '.jb_starrating_deselectable', function(){
	        		SetFieldProperty('jbStarratingDeselectable', $(this).prop('checked'));
	        	});

	        	$(document).on('change', '.jb_starrating_show_tooltip', function(){
	        		SetFieldProperty('jbStarratingShowTooltip', $(this).prop('checked'));
	        	});

	        	$(document).on('mousedown', '.field-choice-row[data-input_type="jb_starrating"] [type="radio"]', function(e){
	        		var ths = $(this);

	        		if(ths.prop('checked')){
	                    SetFieldProperty('defaultValue', '');
	        			setTimeout(function(){
	        				ths.prop('checked',false);
	        			},200);	
	        		}else{
	        			SetFieldProperty('defaultValue', ths.siblings('.field-choice-value').val());
	        		}
	        	});

	        	initializeJbStarrating($('.gfield_jb_starrating'));
	        });

	        function SetDefaultValues_jb_starrating(field) {
				field.label = 'Untitled Rating Field';
			    field.choices = [
				    new Choice('Very Poor'), 
				    new Choice('Poor'), 
				    new Choice('Fair'),
				    new Choice('Good'),
				    new Choice('Excellent')
			    ];
			}

			function initializeJbStarrating(el){
				el.each(function(){

					var ths = jQuery(this);	

					if(ths.parent().hasClass('br-wrapper') || ths.next().hasClass('br-widget')){
						ths.barrating('destroy');
					}
			  		
			  		var theme 			= ths.attr('data-starrating-theme'),
			  			show_selected 	= ths.attr('data-starrating-show-selected'),
			  			deselectable 	= ths.attr('data-starrating-deselectable'),
			  			value 			= ths.attr('data-starrating-value');
			  			
			  		var options = {
			  			theme 				: ((theme != "") ? theme : 'fontawesome-stars' ),
			  			allowEmpty 			: (((deselectable != "" && deselectable == '1') || value == "") ? true : false ),
			    		deselectable 		: ((deselectable != "" && deselectable == '1') ? true : false ),
			    		showSelectedRating 	: ((show_selected != "" && (show_selected == '1' || show_selected == "true")) ? true : false ),
			  		}

			  		ths.barrating(options);
			  		ths.barrating('set', value);
	                ths.parent('.br-wrapper').find('a').unbind('click');
				});
			}
	    </script>
	    <?php
	}

	/**
	 * Add additional options to the field appearance settings.
	 *
	 * @since    1.0.0
	 */
	public function field_appearance_settings( $position, $form_id ) {

	    if ( $position == 50 ) {
	        ?>
	        <li class="jb_starrating_theme_setting field_setting">
	            <label for="jb_starrating_theme" class="section_label">
	                <?php esc_html_e( 'Star Rating Style', 'gravityforms' ); ?>
	                <?php gform_tooltip( 'form_jb_starrating_theme' ) ?>
	            </label>
	        	<select class="jb_starrating_theme" id="jb_starrating_theme">
	    			<option value="fontawesome-stars" selected><?php esc_html_e( 'Star 1', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-stars-o" selected><?php esc_html_e( 'Star 2', 'gravityforms' ); ?></option>
	    			<option value="css-stars"><?php esc_html_e( 'Star 3', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-heart"><?php esc_html_e( 'Heart', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-thumbs"><?php esc_html_e( 'Thumbs Up', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-smiley"><?php esc_html_e( 'Smiley', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-circle"><?php esc_html_e( 'Circle', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-square"><?php esc_html_e( 'Square', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-check-circle"><?php esc_html_e( 'Check Circle', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-check-square"><?php esc_html_e( 'Check Square', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-plus-circle"><?php esc_html_e( 'Plus Circle', 'gravityforms' ); ?></option>
	    			<option value="fontawesome-plus-square"><?php esc_html_e( 'Plus Square', 'gravityforms' ); ?></option>
	    			<option value="bars-vertical"><?php esc_html_e( 'Bar Vertical', 'gravityforms' ); ?></option>
	    			<option value="bars-horizontal"><?php esc_html_e( 'Bar Horizontal', 'gravityforms' ); ?></option>
				</select>
	        </li>
	        <li class="jb_starrating_show_selected_setting field_setting">
	            <label for="jb_starrating_show_selected">
	            	<input type="checkbox" id="jb_starrating_show_selected" class="jb_starrating_show_selected"/>
	                <?php esc_html_e( 'Show Selected Rating', 'gravityforms' ); ?>
	                <?php gform_tooltip( 'form_jb_starrating_show_selected' ) ?>
	            </label>
	        </li>
	        <li class="jb_starrating_show_tooltip_setting field_setting">
	            <label for="jb_starrating_show_tooltip">
	            	<input type="checkbox" id="jb_starrating_show_tooltip" class="jb_starrating_show_tooltip"/>
	                <?php esc_html_e( 'Show Tooltip on Hover', 'gravityforms' ); ?>
	                <?php gform_tooltip( 'form_jb_starrating_show_tooltip' ) ?>
	            </label>
	        </li>
	        <li class="jb_starrating_deselectable_setting field_setting">
	            <label for="jb_starrating_deselectable">
	            	<input type="checkbox" id="jb_starrating_deselectable" class="jb_starrating_deselectable"/>
	                <?php esc_html_e( 'Deselectable', 'gravityforms' ); ?>
	                <?php gform_tooltip( 'form_jb_starrating_deselectable' ) ?>
	            </label>
	        </li>
	        <?php
	    }
	}

	/**
	 * Add tooltips to the options on field appearance settings.
	 *
	 * @since    1.0.0
	 */
	public function field_tooltips( $tooltips ) {
	   $tooltips['form_jb_starrating_theme'] = "<h6>Star Rating Style</h6>Select the rating style for your field.";
	   $tooltips['form_jb_starrating_show_selected'] = "<h6>Show Selected Rating</h6>Check this box to show user selected rating next to the rating widget.";
	   $tooltips['form_jb_starrating_show_tooltip'] = "<h6>Show Tooltip on Hover</h6>Check this box to show tooltip on the current hovered rating icon.";
	   $tooltips['form_jb_starrating_deselectable'] = "<h6>Show Selected Rating</h6>If check, users will be able to deselect ratings.";
	   return $tooltips;
	}

	/**
	 * This will modify the way the field content is rendered.
	 *
	 * @since    1.0.0
	 */
	public function field_content( $content, $field, $value, $lead_id, $form_id ) {

		if ( $field->type == 'jb_starrating' ) {

			$jb_starrating_theme = sprintf( ' data-starrating-theme="%s" ', esc_attr( $field->jbStarratingTheme ) );
			$jb_starrating_value = sprintf( ' data-starrating-value="%s" ', esc_attr( $field->defaultValue ) );
	        $jb_starrating_submit_value = sprintf( ' data-starrating-submit-value="%s" ', esc_attr( $value ) );
			$jb_starrating_show_selected = sprintf( ' data-starrating-show-selected="%s" ', esc_attr( $field->jbStarratingShowSelected ) );
			$jb_starrating_show_tooltip = sprintf( ' data-starrating-show-tooltip="%s" ', esc_attr( $field->jbStarratingShowTooltip ) );
			$jb_starrating_deselectable = sprintf( ' data-starrating-deselectable="%s" ', esc_attr( $field->jbStarratingDeselectable ) );

			$content = str_replace( "data-starrating-theme", $jb_starrating_theme, $content );
			$content = str_replace( "data-starrating-value", $jb_starrating_value, $content );
	        $content = str_replace( "data-starrating-submit-value", $jb_starrating_submit_value, $content );
			$content = str_replace( "data-starrating-show-selected", $jb_starrating_show_selected, $content );
			$content = str_replace( "data-starrating-show-tooltip", $jb_starrating_show_tooltip, $content );
			$content = str_replace( "data-starrating-deselectable", $jb_starrating_deselectable, $content );

		}

		return $content;
	}

}


if ( ! class_exists( 'GFForms' ) ) {
    die();
}

class GF_Field_JBStarrating extends GF_Field {

	public $type = 'jb_starrating';

	public function get_form_editor_field_title() {
		return esc_attr__( 'Star Rating', 'gravityforms' );
	}

	public function get_form_editor_button() {
		return array(
			'group' => 'advanced_fields',
			'text'  => $this->get_form_editor_field_title()
		);
	}

	public function get_form_editor_field_settings() {
		return array(
			'conditional_logic_field_setting',
			'error_message_setting',
			'label_setting',
			'label_placement_setting',
			'admin_label_setting',
			'choices_setting',
			'rules_setting',
			'visibility_setting',
			'description_setting',
			'css_class_setting',
		);
	}

	public function is_conditional_logic_supported() {
		return true;
	}

	public function get_field_input( $form, $value = '', $entry = null ) {

		$form_id         = absint( $form['id'] );
		$is_entry_detail = $this->is_entry_detail();
		$is_form_editor  = $this->is_form_editor();

		$id       = $this->id;
		$field_id = $is_entry_detail || $is_form_editor || $form_id == 0 ? "input_$id" : 'input_' . $form_id . "_$id";

		$logic_event        = $this->get_conditional_logic_event( 'change' );
		$size               = $this->size;
		$class_suffix       = $is_entry_detail ? '_admin' : '';
		$class              = $size . $class_suffix;
		$css_class          = trim( esc_attr( $class ) . ' gfield_jb_starrating' );
		$tabindex           = $this->get_tabindex();
		$disabled_text      = $is_form_editor ? 'disabled="disabled"' : '';
		$required_attribute = $this->isRequired ? 'aria-required="true"' : '';
		$invalid_attribute  = $this->failed_validation ? 'aria-invalid="true"' : 'aria-invalid="false"';

		return sprintf( "<div class='ginput_container ginput_container_jb_starrating'><select data-starrating-theme data-starrating-value data-starrating-submit-value data-starrating-show-selected data-starrating-show-tooltip data-starrating-deselectable name='input_%d' id='%s' $logic_event class='%s' $tabindex %s %s %s>%s</select></div>", $id, $field_id, $css_class, $disabled_text, $required_attribute, $invalid_attribute, $this->get_choices( $value ) );
	}

	public function get_choices( $value ) {
		return GFCommon::get_select_choices( $this, $value );
	}
}

GF_Fields::register( new GF_Field_JBStarrating() );