<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://codecanyon.net/user/butsokoy
 * @since      1.0.0
 *
 * @package    Gform_Starrating_Field
 * @subpackage Gform_Starrating_Field/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Gform_Starrating_Field
 * @subpackage Gform_Starrating_Field/includes
 * @author     Butsokoy <luffy2015x@gmail.com>
 */
class Gform_Starrating_Field_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'gform-starrating-field',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
