jQuery(document).ready(function($){
    function init(){
        if($('.gfield_jb_starrating').length){
            $('.gfield_jb_starrating').each(function(){

                var ths = $(this); 

                if(ths.parent().hasClass('br-wrapper') || ths.next().hasClass('br-widget')){
                    ths.barrating('destroy');
                }
                
                var theme           = ths.attr('data-starrating-theme'),
                    show_selected   = ths.attr('data-starrating-show-selected'),
                    show_tooltip    = ths.attr('data-starrating-show-tooltip'),
                    deselectable    = ths.attr('data-starrating-deselectable'),
                    value           = ths.attr('data-starrating-value'),
                    submit_value    = ths.attr('data-starrating-submit-value');     

                var rating_options = {
                    theme               : ((theme != "") ? theme : 'fontawesome-stars' ),
                    allowEmpty          : (((deselectable != "" && deselectable == '1') || value == "") ? true : false ),
                    deselectable        : ((deselectable != "" && deselectable == '1') ? true : false ),
                    showSelectedRating  : ((show_selected != "" && (show_selected == '1' || show_selected == "true")) ? true : false ),
                }

                ths.barrating(rating_options);

                if(submit_value != "")
                    ths.barrating('set', submit_value);
                else
                    ths.barrating('set', value);

                if(show_tooltip != "" && (show_tooltip == '1' || show_tooltip == "true")){
                   ths.parent().find('a').each(function(){
                        var tooltip_options = {
                            'data-tooltip'          : $(this).attr('data-rating-text'),
                            'data-tooltip-delay'    : 100,
                            'data-tooltip-color'    : 'charcoal',
                            'data-tooltip-stickto'  : 'top',
                            'data-tooltip-animate-function' : 'scalein'
                        }
                        $(this).attr(tooltip_options);
                    }); 
                }
            });
        }
    }
    init();
    jQuery(document).on('gform_post_render', function(){
        init();
    });
});